/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.widget;

import dev.lambdaurora.spruceui.Position;
import dev.lambdaurora.spruceui.navigation.NavigationEvent;
import dev.lambdaurora.spruceui.render.SpruceGuiGraphics;
import dev.lambdaurora.spruceui.widget.SpruceWidget;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpruceWidget
implements SpruceWidget {
    protected final class_310 client = class_310.method_1551();
    protected final Position position;
    private boolean visible;
    protected int width;
    protected int height;
    protected boolean active = true;
    protected boolean focused = false;
    protected boolean hovered = false;
    protected boolean wasHovered = false;
    protected boolean dragging = false;
    protected long lastDrag = 0L;

    public AbstractSpruceWidget(Position position) {
        this.position = position;
        this.visible = true;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public boolean method_37303() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        if (this.focused) {
            return class_6379.class_6380.field_33786;
        }
        if (this.hovered) {
            return class_6379.class_6380.field_33785;
        }
        return class_6379.class_6380.field_33784;
    }

    @Override
    public boolean isMouseHovered() {
        return this.hovered;
    }

    @Override
    public boolean method_25370() {
        return this.focused;
    }

    @Override
    public void method_25365(boolean focused) {
        this.focused = focused;
        if (!focused) {
            this.dragging = false;
        }
    }

    @Override
    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    @Override
    public boolean onNavigation(@NotNull NavigationEvent event) {
        if (this.requiresCursor()) {
            return false;
        }
        if (this.isVisible() && this.method_37303()) {
            this.method_25365(!this.method_25370());
            return this.method_25370();
        }
        return false;
    }

    public boolean method_25402(@NotNull class_11909 event, boolean doubleClick) {
        if (!(this.method_37303() && this.isVisible() && this.method_25405(event.comp_4798(), event.comp_4799()))) {
            return false;
        }
        return this.onMouseClick(event, doubleClick);
    }

    protected boolean onMouseClick(@NotNull class_11909 event, boolean doubleClick) {
        return false;
    }

    public boolean method_25406(@NotNull class_11909 event) {
        boolean result = this.onMouseRelease(event);
        if (result) {
            this.dragging = false;
        }
        return result;
    }

    protected boolean onMouseRelease(@NotNull class_11909 event) {
        return false;
    }

    public boolean method_25403(@NotNull class_11909 event, double deltaX, double deltaY) {
        if (!this.method_37303() || !this.isVisible()) {
            return false;
        }
        boolean result = this.onMouseDrag(event, deltaX, deltaY);
        if (result) {
            this.dragging = true;
            this.lastDrag = class_156.method_658();
        }
        return result;
    }

    protected boolean onMouseDrag(@NotNull class_11909 event, double deltaX, double deltaY) {
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.method_37303() && this.isVisible() && this.method_25405(mouseX, mouseY)) {
            return this.onMouseScroll(mouseX, mouseY, scrollX, scrollY);
        }
        return false;
    }

    protected boolean onMouseScroll(double mouseX, double mouseY, double scrollX, double scrollY) {
        return false;
    }

    public boolean method_25404(@NotNull class_11908 event) {
        if (this.method_37303() && this.isVisible()) {
            return this.onKeyPress(event);
        }
        return false;
    }

    protected boolean onKeyPress(@NotNull class_11908 event) {
        return false;
    }

    public boolean method_16803(@NotNull class_11908 event) {
        if (this.method_37303() && this.isVisible()) {
            return this.onKeyRelease(event);
        }
        return false;
    }

    protected boolean onKeyRelease(@NotNull class_11908 event) {
        return false;
    }

    public boolean method_25400(@NotNull class_11905 event) {
        if (this.method_37303() && this.isVisible()) {
            return this.onCharTyped(event);
        }
        return false;
    }

    protected boolean onCharTyped(@NotNull class_11905 event) {
        return false;
    }

    @Override
    public final void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float delta) {
        this.render(new SpruceGuiGraphics(graphics), mouseX, mouseY, delta);
    }

    @Override
    public void render(@NotNull SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
        if (this.isVisible()) {
            boolean bl = this.hovered = mouseX >= this.getX() && mouseY >= this.getY() && mouseX < this.getX() + this.getWidth() && mouseY < this.getY() + this.getHeight();
            if (this.dragging && !this.isMouseHovered() && class_156.method_658() - this.lastDrag > 60L) {
                this.dragging = false;
            }
            this.renderBackground(graphics, mouseX, mouseY, delta);
            this.renderWidget(graphics, mouseX, mouseY, delta);
            this.wasHovered = this.isMouseHovered();
        } else {
            this.wasHovered = false;
            this.hovered = false;
        }
    }

    protected abstract void renderWidget(SpruceGuiGraphics var1, int var2, int var3, float var4);

    protected void renderBackground(SpruceGuiGraphics graphics, int mouseX, int mouseY, float delta) {
    }

    public void playDownSound() {
        this.client.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f));
    }

    public void method_37020(class_6382 builder) {
        class_2561 narrationMessage = this.getNarrationMessage();
        if (narrationMessage != null) {
            builder.method_37034(class_6381.field_33788, narrationMessage);
        }
    }

    @Nullable
    protected class_2561 getNarrationMessage() {
        return null;
    }
}

